﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Utilities;
using System.Threading;
using System.Diagnostics;
using System.IO;
using System.Configuration;
using iTextSharp.text;
using iTextSharp.text.pdf;
using iTextSharp.awt;
using iTextSharp.xmp;
using iTextSharp.text.html.simpleparser;

namespace AZVIC.Ei8htPOS.WebUI
{
    public static class GeneratePDF
    {
        public static void GenerateInvoicePDF(Guid ordersID, bool isDownload, HttpResponse response)
        {
            Orders currOrder = OrdersBL.GetItem(ordersID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

            MemoryStream output;
            using (output = new MemoryStream())
            {
                Document myDocument = new Document(PageSize.A4);

                PdfWriter writer = PdfWriter.GetInstance(myDocument, output);
                myDocument.Open();
                myDocument.NewPage();

                PdfPCell pCell = null;

                PdfPTable pTable = new PdfPTable(2);

                #region Adding Header
                Paragraph para;
                string address = string.Empty;
                float[] widths = new float[] { 250f, 250f };

                myDocument.Add(AddHeader());
                #endregion

                #region Adding Invoice & GST Caption
                pTable = new PdfPTable(1);
                pTable.TotalWidth = 500f;

                para = new Paragraph("\n\nTAX INVOICE\n", new Font(Font.FontFamily.HELVETICA, 12f, Font.BOLD, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_CENTER;
                pCell = new PdfPCell(para);
                pCell.Border = Rectangle.NO_BORDER;
                pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                para = new Paragraph("GST No. 53191999D\n\n", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_JUSTIFIED;
                pCell = new PdfPCell(para);
                pCell.Border = Rectangle.NO_BORDER;
                pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                myDocument.Add(pTable);
                #endregion

                #region Billing & Shipping Address
                pTable = new PdfPTable(3);
                pTable.TotalWidth = 500f;

                address = string.Format("\n{0} {1}\n", currOrder.FirstName, currOrder.LastName) +
                    string.Format("{0}{1}\n", currOrder.BillingAddress1, string.IsNullOrEmpty(currOrder.BillingAddress2) ? string.Empty : "\n" + currOrder.BillingAddress2) +
                                   string.Format("{0}\n{1}\n", currOrder.BillingCity, currOrder.BillingState) +
                                   string.Format("{0} - {1}\n", currOrder.BillingCountry, currOrder.BillingPostalCode) +
                                   string.Format("Mobile: {0}", currOrder.BillingMobile);

                Phrase pphrase = new Phrase();
                pphrase.Add(new Chunk("BILL TO", FontFactory.GetFont(FontFactory.HELVETICA, 12f, Font.BOLD, BaseColor.BLACK)));
                pphrase.Add(new Chunk(address, FontFactory.GetFont(FontFactory.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK)));
                pCell = new PdfPCell(pphrase);
                pCell.SetLeading(1f, 1.5f);
                pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                address = string.Format("\n{0} {1}\n", currOrder.FirstName, currOrder.LastName) +
                                   string.Format("{0}{1}\n", currOrder.ShippingAddress1, string.IsNullOrEmpty(currOrder.ShippingAddress2) ? string.Empty : "\n" + currOrder.ShippingAddress2) +
                                   string.Format("{0}\n{1}\n", currOrder.ShippingCity, currOrder.ShippingState) +
                                   string.Format("{0} - {1}\n", currOrder.ShippingCountry, currOrder.ShippingPostalCode) +
                                   string.Format("Mobile: {0}", currOrder.ShippingMobile);

                pphrase = new Phrase();
                pphrase.Add(new Chunk("DELIVER TO", FontFactory.GetFont(FontFactory.HELVETICA, 12f, Font.BOLD, BaseColor.BLACK)));
                pphrase.Add(new Chunk(address, FontFactory.GetFont(FontFactory.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK)));

                pCell = new PdfPCell(pphrase);
                pCell.SetLeading(1f, 1.5f);
                pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                address = string.Format("INVOICE NO: {0}\n", currOrder.InvoiceNo) +
                            string.Format("Order Date: {0}\n", currOrder.CreatedDate.ToString("dd/MM/yyyy")) +
                            string.Format("Payment Method: {0}\n", currOrder.PaymentMethod) +
                            string.Format("Sales Order No: {0}\n", currOrder.OrderNumber) +
                            string.Format("Sales Order Date: {0}\n", currOrder.CreatedDate.ToString("dd/MM/yyyy"));

                pphrase = new Phrase();
                pphrase.Add(new Chunk(address, FontFactory.GetFont(FontFactory.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK)));
                pCell = new PdfPCell(pphrase);
                pCell.SetLeading(1f, 1.5f);
                pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                myDocument.Add(pTable);
                #endregion

                #region Items Table Header

                int Pagesize = 15;
                int Threshold = 7;
                bool isLastPage = false, applyPageBreak = false;
                int OrderCount = currOrder.OrdersDetailsList.Count;
                int NoOfPages = OrderCount / Pagesize;

                for (int page = 0; page <= NoOfPages; page++)
                {
                    isLastPage = page == NoOfPages ? true : false;
                    if (isLastPage)
                    {
                        //Merge with Item Details
                        if (OrderCount - (page * Pagesize) <= Threshold)
                        {
                            applyPageBreak = true;
                        }
                        else
                        {
                            applyPageBreak = false;
                        }
                    }
                    //If Last Page has more than the threshold, Initiate a new page
                    if ((page > 0))
                    {
                        myDocument.NewPage();

                        myDocument.Add(AddHeader());
                        //Only if some elements are left to be printed, Add Header - Otherwise ignore it 
                        if (OrderCount - (page * Pagesize) <= 0)
                        {
                            applyPageBreak = false;
                        }
                    }

                    if (OrderCount - (page * Pagesize) > 0)
                    {
                        pTable = new PdfPTable(1);
                        pTable.TotalWidth = 500f;

                        para = new Paragraph("\n\n  ", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_CENTER;
                        pCell = new PdfPCell(para);
                        pCell.Border = Rectangle.NO_BORDER;
                        pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                        pCell.VerticalAlignment = Element.ALIGN_TOP;
                        pTable.AddCell(pCell);
                        myDocument.Add(pTable);

                        myDocument.Add(ItemDetailHeaders());
                    }

                    #region Items Table
                    for (int order = 0; order < Pagesize; order++)
                    {
                        int currOrderNo = page * Pagesize + order;
                        int slNo = currOrderNo + 1;
                        if (currOrderNo >= currOrder.OrdersDetailsList.Count)
                        {
                            break;
                        }
                        pTable = new PdfPTable(5);
                        pTable.TotalWidth = 500f;
                        widths = new float[] { 50f, 250f, 50f, 75f, 75f };
                        pTable.SetWidths(widths);

                        para = new Paragraph(slNo++.ToString(), new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_CENTER;
                        pCell = new PdfPCell(para);
                        pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                        pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                        pTable.AddCell(pCell);

                        para = new Paragraph(currOrder.OrdersDetailsList[order].ProductName, new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_LEFT;
                        pCell = new PdfPCell(para);
                        pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                        pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                        pTable.AddCell(pCell);

                        para = new Paragraph(currOrder.OrdersDetailsList[order].Quantity.ToString(), new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_CENTER;
                        pCell = new PdfPCell(para);
                        pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                        pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                        pTable.AddCell(pCell);

                        para = new Paragraph(currOrder.OrdersDetailsList[order].OrderPrice.ToString("0.00"), new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_CENTER;
                        pCell = new PdfPCell(para);
                        pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                        pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                        pTable.AddCell(pCell);

                        para = new Paragraph(currOrder.OrdersDetailsList[order].Amount.ToString("0.00"), new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_RIGHT;
                        pCell = new PdfPCell(para);
                        pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                        pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                        pTable.AddCell(pCell);

                        myDocument.Add(pTable);

                    }
                    #endregion
                }
                #endregion

                #region Total Column
                pTable = new PdfPTable(3);
                pTable.TotalWidth = 500f;
                widths = new float[] { 350f, 75f, 75f };
                pTable.SetWidths(widths);

                para = new Paragraph("Sub Total:\nDiscount:\nShipping\nTotal Before GST:\nGST\nGrand Total:\nPayment:\nAmount Payable:\n", new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_RIGHT;
                pCell = new PdfPCell(para);
                pCell.SetLeading(1f, 1.5f);
                pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                pTable.AddCell(pCell);

                para = new Paragraph("SGD\nSGD\nSGD\nSGD\nSGD\nSGD\nSGD\nSGD\n", new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_RIGHT;
                pCell = new PdfPCell(para);
                pCell.SetLeading(1f, 1.5f);
                pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                pTable.AddCell(pCell);

                address = string.Format("{0}\n", currOrder.SubTotal.ToString("0.00")) +
                    string.Format("{0}\n", currOrder.Discount.ToString("0.00")) +
                    string.Format("{0}\n", currOrder.Shipping.ToString("0.00")) +
                    string.Format("{0}\n", currOrder.TotalBeforeGST.ToString("0.00")) +
                    string.Format("{0}\n", currOrder.GST.ToString("0.00")) +
                    string.Format("{0}\n", currOrder.Total.ToString("0.00")) +
                    string.Format("{0}\n", currOrder.PaidAmount.ToString("0.00")) +
                    string.Format("{0}\n", ((currOrder.Total - currOrder.PaidAmount) >= 0 ? (currOrder.Total - currOrder.PaidAmount) : 0).ToString("0.00"));

                para = new Paragraph(address, new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_RIGHT;
                pCell = new PdfPCell(para);
                pCell.SetLeading(1f, 1.5f);
                pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                pTable.AddCell(pCell);

                if ((!applyPageBreak) && (NoOfPages == 0))
                {
                    myDocument.NewPage();
                    myDocument.Add(AddHeader());

                    pTable = new PdfPTable(1);
                    pTable.TotalWidth = 500f;

                    para = new Paragraph("\n  ", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
                    para.Alignment = Element.ALIGN_CENTER;
                    pCell = new PdfPCell(para);
                    pCell.Border = Rectangle.NO_BORDER;
                    pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                    pCell.VerticalAlignment = Element.ALIGN_TOP;
                    pTable.AddCell(pCell);

                    myDocument.Add(pTable);
                }

                myDocument.Add(pTable);

                #endregion

                pTable = new PdfPTable(1);
                pTable.TotalWidth = 500f;

                para = new Paragraph("\n\nAcknowledge By Customer:\n\n\n\n\n\n\n\n_______________________________\nSignature / Stamp\nDate:", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_RIGHT;
                pCell = new PdfPCell(para);
                pCell.SetLeading(1f, 1.5f);
                pCell.Border = Rectangle.NO_BORDER;
                pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                para = new Paragraph("This is a computer generated document and requires no signature.\n\n", new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_LEFT;
                pCell = new PdfPCell(para);
                pCell.Border = Rectangle.NO_BORDER;
                pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                myDocument.Add(pTable);

                myDocument.Close();
            }

            if (isDownload)
            {
                response.ClearContent();
                response.ClearHeaders();
                response.ContentType = "application/pdf";
                response.AddHeader("content-disposition", "attachment; filename=Invoice.pdf");
                response.BinaryWrite(output.ToArray());
            }
            else
            {
                response.ClearContent();
                response.ClearHeaders();
                response.ContentType = "application/pdf";
                response.BinaryWrite(output.ToArray());
            }

            response.Flush();
            response.Clear();
            response.End();

            //if (isDownload)
            //{
            //    response.ClearContent();
            //    response.ClearHeaders();
            //    response.ContentType = "application/pdf";
            //    response.AddHeader("content-disposition", "attachment; filename=Invoice.pdf");
            //}
            //else
            //{
            //    response.ClearContent();
            //    response.ClearHeaders();
            //    response.ContentType = "application/pdf";
            //    response.AddHeader("content-disposition", "inline; filename=\"" + "Invoice.pdf " + "\"");
            //}

            //response.BinaryWrite(output.ToArray());

            //response.Flush();
            //response.Close();
            //response.End();
        }

        private static PdfPTable AddHeader()
        {
            PdfPTable pTable = new PdfPTable(2);
            PdfPCell pCell = null;
            pTable.TotalWidth = 500f;
            float[] widths = new float[] { 250f, 250f };
            pTable.SetWidths(widths);

            iTextSharp.text.Image pic = iTextSharp.text.Image.GetInstance(HttpContext.Current.Server.MapPath("~/Admin/Images/logo.png"));
            pic.Alignment = Element.ALIGN_LEFT;
            pic.ScaleToFit(80f, 80f);
            pCell = new PdfPCell(pic);
            pCell.Border = Rectangle.NO_BORDER;
            pCell.HorizontalAlignment = Element.ALIGN_LEFT;
            pCell.VerticalAlignment = Element.ALIGN_TOP;
            pTable.AddCell(pCell);

            string address = "8 Burn Road\n#04-01 Trivex\nSingapore\nReg.No. 53191999D\nTel: (65)  6636 8819\nFax: (65) 6725 0966\nEmail: sales@azvic.com.sg\nWebsite: www.ei8htpos.com.sg";

            Paragraph para = new Paragraph(address, new Font(Font.FontFamily.HELVETICA, 7f, Font.BOLD, BaseColor.BLACK));
            para.Alignment = Element.ALIGN_LEFT;
            pCell = new PdfPCell(para);
            pCell.SetLeading(1f, 1.5f);
            pCell.Border = iTextSharp.text.Rectangle.NO_BORDER;
            pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
            pCell.VerticalAlignment = Element.ALIGN_TOP;
            pTable.AddCell(pCell);

            para = new Paragraph("\n\n ", new Font(Font.FontFamily.HELVETICA, 7f, Font.BOLD, BaseColor.BLACK));
            para.Alignment = Element.ALIGN_LEFT;
            pCell = new PdfPCell(para);
            pCell.SetLeading(1f, 1.5f);
            pCell.Border = iTextSharp.text.Rectangle.NO_BORDER;
            pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
            pCell.VerticalAlignment = Element.ALIGN_TOP;
            pTable.AddCell(pCell);

            return pTable;
        }

        private static PdfPTable ItemDetailHeaders()
        {

            PdfPTable pTable1 = new PdfPTable(5);
            pTable1.TotalWidth = 500f;
            float[] widths = new float[] { 50f, 250f, 50f, 75f, 75f };
            pTable1.SetWidths(widths);

            Paragraph para2 = new Paragraph("Sl.No", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
            para2.Alignment = Element.ALIGN_CENTER;
            PdfPCell pCell2 = new PdfPCell(para2);
            pCell2.HorizontalAlignment = Element.ALIGN_CENTER;
            pCell2.VerticalAlignment = Element.ALIGN_MIDDLE;
            pTable1.AddCell(pCell2);

            para2 = new Paragraph("Item Descriptions", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
            para2.Alignment = Element.ALIGN_CENTER;
            pCell2 = new PdfPCell(para2);
            pCell2.HorizontalAlignment = Element.ALIGN_CENTER;
            pCell2.VerticalAlignment = Element.ALIGN_MIDDLE;
            pTable1.AddCell(pCell2);

            para2 = new Paragraph("Qty", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
            para2.Alignment = Element.ALIGN_CENTER;
            pCell2 = new PdfPCell(para2);
            pCell2.HorizontalAlignment = Element.ALIGN_CENTER;
            pCell2.VerticalAlignment = Element.ALIGN_MIDDLE;
            pTable1.AddCell(pCell2);

            para2 = new Paragraph("Unit Price", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
            para2.Alignment = Element.ALIGN_CENTER;
            pCell2 = new PdfPCell(para2);
            pCell2.HorizontalAlignment = Element.ALIGN_CENTER;
            pCell2.VerticalAlignment = Element.ALIGN_MIDDLE;
            pTable1.AddCell(pCell2);

            para2 = new Paragraph("Amount", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
            para2.Alignment = Element.ALIGN_CENTER;
            pCell2 = new PdfPCell(para2);
            pCell2.HorizontalAlignment = Element.ALIGN_CENTER;
            pCell2.VerticalAlignment = Element.ALIGN_MIDDLE;
            pTable1.AddCell(pCell2);

            return pTable1;

        }

        private static PdfPTable ItemDODetailHeaders()
        {
            PdfPTable pTable1 = new PdfPTable(3);
            pTable1.TotalWidth = 500f;
            float[] widths = new float[] { 50f, 400f, 50f };
            pTable1.SetWidths(widths);

            Paragraph para2 = new Paragraph("Sl.No", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
            para2.Alignment = Element.ALIGN_CENTER;
            PdfPCell pCell2 = new PdfPCell(para2);
            pCell2.HorizontalAlignment = Element.ALIGN_CENTER;
            pCell2.VerticalAlignment = Element.ALIGN_MIDDLE;
            pTable1.AddCell(pCell2);

            para2 = new Paragraph("Item Descriptions", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
            para2.Alignment = Element.ALIGN_CENTER;
            pCell2 = new PdfPCell(para2);
            pCell2.HorizontalAlignment = Element.ALIGN_CENTER;
            pCell2.VerticalAlignment = Element.ALIGN_MIDDLE;
            pTable1.AddCell(pCell2);

            para2 = new Paragraph("Qty", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
            para2.Alignment = Element.ALIGN_CENTER;
            pCell2 = new PdfPCell(para2);
            pCell2.HorizontalAlignment = Element.ALIGN_CENTER;
            pCell2.VerticalAlignment = Element.ALIGN_MIDDLE;
            pTable1.AddCell(pCell2);

            return pTable1;
        }

        public static void GenerateDOPDF(Guid ordersID, string doNumber, bool isDownload, HttpResponse response)
        {
            Orders currOrder = OrdersBL.GetItem(ordersID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);

            currOrder.OrdersDetailsList = (from od in currOrder.OrdersDetailsList
                                           where od.DONumber == doNumber
                                           select od).ToList();

            OrdersDetails odet = (from od in currOrder.OrdersDetailsList
                                  select od).FirstOrDefault<OrdersDetails>();

            MemoryStream output;
            using (output = new MemoryStream())
            {
                Document myDocument = new Document(PageSize.A4);

                PdfWriter writer = PdfWriter.GetInstance(myDocument, output);
                myDocument.Open();
                myDocument.NewPage();

                PdfPCell pCell = null;

                PdfPTable pTable = new PdfPTable(2);
                Paragraph para;
                string address = string.Empty;
                float[] widths = new float[] { 250f, 250f };


                #region Adding Header
                myDocument.Add(AddHeader());
                #endregion

                #region Adding Invoice & GST Caption
                pTable = new PdfPTable(1);
                pTable.TotalWidth = 500f;

                para = new Paragraph("\n\nDELIVERY ORDER\n", new Font(Font.FontFamily.HELVETICA, 12f, Font.BOLD, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_CENTER;
                pCell = new PdfPCell(para);
                pCell.Border = Rectangle.NO_BORDER;
                pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                para = new Paragraph("GST No. 53191999D\n\n", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_JUSTIFIED;
                pCell = new PdfPCell(para);
                pCell.Border = Rectangle.NO_BORDER;
                pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                myDocument.Add(pTable);
                #endregion

                #region Billing & Shipping Address
                pTable = new PdfPTable(3);
                pTable.TotalWidth = 500f;

                address = string.Format("\n{0} {1}\n", currOrder.FirstName, currOrder.LastName) +
                    string.Format("{0}{1}\n", currOrder.BillingAddress1, string.IsNullOrEmpty(currOrder.BillingAddress2) ? string.Empty : "\n" + currOrder.BillingAddress2) +
                                   string.Format("{0}\n{1}\n", currOrder.BillingCity, currOrder.BillingState) +
                                   string.Format("{0} - {1}\n", currOrder.BillingCountry, currOrder.BillingPostalCode) +
                                   string.Format("Mobile: {0}", currOrder.BillingMobile);

                Phrase pphrase = new Phrase();
                pphrase.Add(new Chunk("BILL TO", FontFactory.GetFont(FontFactory.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK)));
                pphrase.Add(new Chunk(address, FontFactory.GetFont(FontFactory.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK)));
                pCell = new PdfPCell(pphrase);
                pCell.SetLeading(1f, 1.5f);
                pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                address = string.Format("\n{0} {1}\n", currOrder.FirstName, currOrder.LastName) +
                                   string.Format("{0}{1}\n", currOrder.ShippingAddress1, string.IsNullOrEmpty(currOrder.ShippingAddress2) ? string.Empty : "\n" + currOrder.ShippingAddress2) +
                                   string.Format("{0}\n{1}\n", currOrder.ShippingCity, currOrder.ShippingState) +
                                   string.Format("{0} - {1}\n", currOrder.ShippingCountry, currOrder.ShippingPostalCode) +
                                   string.Format("Mobile: {0}", currOrder.ShippingMobile);

                pphrase = new Phrase();
                pphrase.Add(new Chunk("DELIVER TO", FontFactory.GetFont(FontFactory.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK)));
                pphrase.Add(new Chunk(address, FontFactory.GetFont(FontFactory.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK)));

                pCell = new PdfPCell(pphrase);
                pCell.SetLeading(1f, 1.5f);
                pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                address = string.Format("INVOICE NO: {0}\n", currOrder.InvoiceNo) +
                            string.Format("Order Date: {0}\n", currOrder.CreatedDate.ToString("dd/MM/yyyy")) +
                            string.Format("Payment Method: {0}\n", currOrder.PaymentMethod) +
                            string.Format("DO No: {0}\n", odet.DONumber) +
                            string.Format("DO Date: {0}\n", odet.DODate.ToString("dd/MM/yyyy"));

                pphrase = new Phrase();
                pphrase.Add(new Chunk(address, FontFactory.GetFont(FontFactory.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK)));
                pCell = new PdfPCell(pphrase);
                pCell.SetLeading(1f, 1.5f);
                pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                myDocument.Add(pTable);
                #endregion

                #region Items Table Header

                int Pagesize = 20;
                int Threshold = 20;
                bool isLastPage = false, applyPageBreak = false;
                int OrderCount = currOrder.OrdersDetailsList.Count;
                int NoOfPages = OrderCount / Pagesize;

                for (int page = 0; page <= NoOfPages; page++)
                {
                    isLastPage = page == NoOfPages ? true : false;
                    if (isLastPage)
                    {
                        //Merge with Item Details
                        if (OrderCount - (page * Pagesize) <= Threshold)
                        {
                            applyPageBreak = true;
                        }
                        else
                        {
                            applyPageBreak = false;
                        }
                    }
                    //If Last Page has more than the threshold, Initiate a new page
                    if ((page > 0))
                    {
                        myDocument.NewPage();

                        myDocument.Add(AddHeader());
                        //Only if some elements are left to be printed, Add Header - Otherwise ignore it 
                        if (OrderCount - (page * Pagesize) <= 0)
                        {
                            applyPageBreak = false;
                        }
                    }

                    if (OrderCount - (page * Pagesize) > 0)
                    {
                        pTable = new PdfPTable(1);
                        pTable.TotalWidth = 500f;

                        para = new Paragraph("\n\n  ", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_CENTER;
                        pCell = new PdfPCell(para);
                        pCell.Border = Rectangle.NO_BORDER;
                        pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                        pCell.VerticalAlignment = Element.ALIGN_TOP;
                        pTable.AddCell(pCell);
                        myDocument.Add(pTable);

                        myDocument.Add(ItemDODetailHeaders());
                    }
                #endregion

                    #region Items Table
                    for (int order = 0; order < Pagesize; order++)
                    {
                        int currOrderNo = page * Pagesize + order;
                        int slNo = currOrderNo + 1;
                        if (currOrderNo >= currOrder.OrdersDetailsList.Count)
                        {
                            break;
                        }
                        pTable = new PdfPTable(3);
                        pTable.TotalWidth = 500f;
                        widths = new float[] { 50f, 400f, 50f };
                        pTable.SetWidths(widths);

                        para = new Paragraph(slNo++.ToString(), new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_CENTER;
                        pCell = new PdfPCell(para);
                        pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                        pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                        pTable.AddCell(pCell);

                        para = new Paragraph(currOrder.OrdersDetailsList[order].ProductName, new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_LEFT;
                        pCell = new PdfPCell(para);
                        pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                        pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                        pTable.AddCell(pCell);

                        para = new Paragraph(currOrder.OrdersDetailsList[order].Quantity.ToString(), new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_CENTER;
                        pCell = new PdfPCell(para);
                        pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                        pCell.VerticalAlignment = Element.ALIGN_MIDDLE;
                        pTable.AddCell(pCell);

                        myDocument.Add(pTable);
                    }
                }
                    #endregion

                pTable = new PdfPTable(1);
                pTable.TotalWidth = 500f;

                para = new Paragraph("\n\nAcknowledge By Customer:\n\n\n\n\n\n\n\n_______________________________\nSignature / Stamp\nDate:", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_RIGHT;
                pCell = new PdfPCell(para);
                pCell.SetLeading(1f, 1.5f);
                pCell.Border = Rectangle.NO_BORDER;
                pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                para = new Paragraph("This is a computer generated document and requires no signature.\n\n", new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_LEFT;
                pCell = new PdfPCell(para);
                pCell.Border = Rectangle.NO_BORDER;
                pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                if ((!applyPageBreak) && (NoOfPages == 0))
                {
                    myDocument.NewPage();
                    myDocument.Add(AddHeader());

                    pTable = new PdfPTable(1);
                    pTable.TotalWidth = 500f;

                    para = new Paragraph("\n  ", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
                    para.Alignment = Element.ALIGN_CENTER;
                    pCell = new PdfPCell(para);
                    pCell.Border = Rectangle.NO_BORDER;
                    pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                    pCell.VerticalAlignment = Element.ALIGN_TOP;
                    pTable.AddCell(pCell);

                    myDocument.Add(pTable);
                }

                myDocument.Add(pTable);

                myDocument.Close();
            }

            if (isDownload)
            {
                response.ClearContent();
                response.ClearHeaders();
                response.ContentType = "application/pdf";
                response.AddHeader("content-disposition", "attachment; filename=DO.pdf");
                response.BinaryWrite(output.ToArray());
            }
            else
            {
                response.ClearContent();
                response.ClearHeaders();
                response.ContentType = "application/pdf";
                response.BinaryWrite(output.ToArray());
            }

            response.Flush();
            response.Clear();
            response.End();
        }

        public static void GenerateQuotationsPDF(Guid quotationsID, bool isDownload, HttpResponse response)
        {
            Quotations currQuote = QuotationsBL.GetItem(quotationsID, string.Empty, DateTime.MinValue, DateTime.MinValue);
            UserAccount adminAccount = UserAccountBL.GetItem(currQuote.AdminUserAccountID, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            MemoryStream output;
            using (output = new MemoryStream())
            {
                Document myDocument = new Document(PageSize.A4);

                PdfWriter writer = PdfWriter.GetInstance(myDocument, output);
                myDocument.Open();
                myDocument.NewPage();

                PdfPCell pCell = null;

                PdfPTable pTable = new PdfPTable(2);

                Paragraph para;
                string address = string.Empty;
                float[] widths = new float[] { 250f, 250f };
                iTextSharp.text.Image pic;

                #region Adding Header
                myDocument.Add(AddHeader());
                #endregion

                #region Adding Invoice & GST Caption
                pTable = new PdfPTable(1);
                pTable.TotalWidth = 500f;

                para = new Paragraph("\n\n\nDate :" + currQuote.CreatedDate.ToString("dd/MM/yyyy") + "\n", new Font(Font.FontFamily.HELVETICA, 9f, Font.BOLD, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_LEFT;
                pCell = new PdfPCell(para);
                pCell.Border = Rectangle.NO_BORDER;
                pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                address = string.Format("\n{0} {1}\n", currQuote.FirstName, currQuote.LastName) +
                    string.Format("{0}{1}\n", currQuote.BillingAddress1, string.IsNullOrEmpty(currQuote.BillingAddress2) ? string.Empty : "\n" + currQuote.BillingAddress2) +
                                   string.Format("{0}\n{1}\n", currQuote.BillingCity, currQuote.BillingState) +
                                   string.Format("{0} - {1}\n", currQuote.BillingCountry, currQuote.BillingPostalCode) +
                                   string.Format("Mobile: {0}", currQuote.BillingMobile);

                para = new Paragraph(address, new Font(Font.FontFamily.HELVETICA, 8f, Font.NORMAL, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_LEFT;
                pCell = new PdfPCell(para);
                pCell.SetLeading(1f, 1.5f);
                pCell.Border = Rectangle.NO_BORDER;
                pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                myDocument.Add(pTable);
                #endregion

                #region Items Table Header

                int Pagesize = 2;
                int Threshold = 2;
                bool isLastPage = false, applyPageBreak = false;
                int OrderCount = currQuote.QuotationsDetailsList.Count;
                int NoOfPages = OrderCount / Pagesize;


                for (int page = 0; page <= NoOfPages; page++)
                {
                    isLastPage = page == NoOfPages ? true : false;
                    if (isLastPage)
                    {
                        //Merge with Item Details
                        if (OrderCount - (page * Pagesize) <= Threshold)
                        {
                            applyPageBreak = true;
                        }
                        else
                        {
                            applyPageBreak = false;
                        }
                    }
                    //If Last Page has more than the threshold, Initiate a new page
                    if ((page > 0))
                    {
                        myDocument.NewPage();

                        myDocument.Add(AddHeader());
                        //Only if some elements are left to be printed, Add Header - Otherwise ignore it 
                        if (OrderCount - (page * Pagesize) <= 0)
                        {
                            applyPageBreak = false;
                        }
                    }

                    if (OrderCount - (page * Pagesize) > 0)
                    {
                        pTable = new PdfPTable(1);
                        pTable.TotalWidth = 500f;

                        para = new Paragraph("\n\n  ", new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_CENTER;
                        pCell = new PdfPCell(para);
                        pCell.Border = Rectangle.NO_BORDER;
                        pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                        pCell.VerticalAlignment = Element.ALIGN_TOP;
                        pTable.AddCell(pCell);
                        myDocument.Add(pTable);

                        myDocument.Add(ItemDetailHeaders());
                    }
                #endregion

                    #region Items Table
                    for (int order = 0; order < Pagesize; order++)
                    {
                        int currOrderNo = page * Pagesize + order;
                        int slNo = currOrderNo + 1;
                        if (currOrderNo >= currQuote.QuotationsDetailsList.Count)
                        {
                            break;
                        }
                        Products curProd = ProductsBL.GetItem(currQuote.QuotationsDetailsList[order].ProductID, string.Empty);

                        pTable = new PdfPTable(5);
                        pTable.TotalWidth = 500f;
                        widths = new float[] { 50f, 250f, 50f, 75f, 75f };
                        pTable.SetWidths(widths);

                        para = new Paragraph(slNo++.ToString(), new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_CENTER;
                        pCell = new PdfPCell(para);
                        pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                        pCell.VerticalAlignment = Element.ALIGN_TOP;
                        pTable.AddCell(pCell);

                        #region Item Descriptions with Image
                        PdfPTable itemTable = new PdfPTable(1);
                        itemTable.TotalWidth = 250f;

                        PdfPCell itemCell = null;

                        address = string.Format("{0}\n{1}", currQuote.QuotationsDetailsList[order].ProductName, string.Format("{0} X {1} X {2}", curProd.ProductHeight.ToString("0.00 cm"), curProd.ProductDepth.ToString("0.00 cm"), curProd.ProductWidth.ToString("0.00 cm")));
                        para = new Paragraph(address, new Font(Font.FontFamily.HELVETICA, 8f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_LEFT;
                        itemCell = new PdfPCell(para);
                        itemCell.Border = Rectangle.NO_BORDER;
                        itemCell.HorizontalAlignment = Element.ALIGN_LEFT;
                        itemCell.VerticalAlignment = Element.ALIGN_TOP;
                        itemTable.AddCell(itemCell);

                        para = new Paragraph(string.Format("{0}\n{1}", curProd.ProductDescriptionsForQuote, currQuote.QuotationsDetailsList[order].Remarks), new Font(Font.FontFamily.HELVETICA, 8f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_LEFT;
                        itemCell = new PdfPCell(para);
                        itemCell.Border = Rectangle.NO_BORDER;
                        itemCell.HorizontalAlignment = Element.ALIGN_LEFT;
                        itemCell.VerticalAlignment = Element.ALIGN_TOP;
                        itemTable.AddCell(itemCell);

                        pic = iTextSharp.text.Image.GetInstance(HttpContext.Current.Server.MapPath("~/Images/ProductsImages/" + (curProd.Image1.Trim().Length != 0 ? curProd.Image1.Trim() : "No-Image1.png")));
                        pic.Alignment = Element.ALIGN_CENTER;
                        pic.ScaleToFit(80f, 80f);
                        itemCell = new PdfPCell(pic);
                        itemCell.Padding = 5f;
                        itemCell.Border = Rectangle.NO_BORDER;
                        itemCell.HorizontalAlignment = Element.ALIGN_LEFT;
                        itemCell.VerticalAlignment = Element.ALIGN_TOP;
                        itemTable.AddCell(itemCell);

                        pCell = new PdfPCell(itemTable);
                        pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                        pCell.VerticalAlignment = Element.ALIGN_TOP;
                        pTable.AddCell(pCell);
                        #endregion

                        para = new Paragraph(currQuote.QuotationsDetailsList[order].Quantity.ToString(), new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_CENTER;
                        pCell = new PdfPCell(para);
                        pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                        pCell.VerticalAlignment = Element.ALIGN_TOP;
                        pTable.AddCell(pCell);

                        para = new Paragraph(currQuote.QuotationsDetailsList[order].OrderPrice.ToString("0.00"), new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_CENTER;
                        pCell = new PdfPCell(para);
                        pCell.HorizontalAlignment = Element.ALIGN_CENTER;
                        pCell.VerticalAlignment = Element.ALIGN_TOP;
                        pTable.AddCell(pCell);

                        para = new Paragraph(currQuote.QuotationsDetailsList[order].Amount.ToString("0.00"), new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                        para.Alignment = Element.ALIGN_RIGHT;
                        pCell = new PdfPCell(para);
                        pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                        pCell.VerticalAlignment = Element.ALIGN_TOP;
                        pTable.AddCell(pCell);

                        myDocument.Add(pTable);
                    }
                }
                    #endregion

                #region Total Column
                pTable = new PdfPTable(3);
                pTable.TotalWidth = 500f;
                widths = new float[] { 350f, 75f, 75f };
                pTable.SetWidths(widths);

                para = new Paragraph("Sub Total:\nDiscount:\nShipping\nTotal Before GST:\nGST\nGrand Total:\n\n"/*Payment:\nAmount Payable:\n"*/, new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_RIGHT;
                pCell = new PdfPCell(para);
                pCell.SetLeading(1f, 1.5f);
                pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                para = new Paragraph("SGD\nSGD\nSGD\nSGD\nSGD\nSGD\n\n"/*SGD\nSGD\n"*/, new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_RIGHT;
                pCell = new PdfPCell(para);
                pCell.SetLeading(1f, 1.5f);
                pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                address = string.Format("{0}\n", currQuote.SubTotal.ToString("0.00")) +
                    string.Format("{0}\n", currQuote.Discount.ToString("0.00")) +
                    string.Format("{0}\n", currQuote.Shipping.ToString("0.00")) +
                    string.Format("{0}\n", currQuote.TotalBeforeGST.ToString("0.00")) +
                   string.Format("{0}\n", currQuote.GST.ToString("0.00")) +
                    string.Format("{0}\n", currQuote.Total.ToString("0.00"));

                para = new Paragraph(address, new Font(Font.FontFamily.HELVETICA, 10f, Font.BOLD, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_RIGHT;
                pCell = new PdfPCell(para);
                pCell.SetLeading(1f, 1.5f);
                pCell.HorizontalAlignment = Element.ALIGN_RIGHT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                myDocument.Add(pTable);
                #endregion

                pTable = new PdfPTable(1);
                pTable.TotalWidth = 500f;

                para = new Paragraph("\n\nQuotation Prepared By: " + (adminAccount != null ? adminAccount.FirstName + " " + adminAccount.LastName : string.Empty) + "\n", new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_LEFT;
                pCell = new PdfPCell(para);
                pCell.Border = Rectangle.NO_BORDER;
                pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                myDocument.Add(pTable);

                pTable = new PdfPTable(1);
                pTable.TotalWidth = 500f;

                para = new Paragraph("\n\nThis is a computer generated document and requires no signature.\n\n", new Font(Font.FontFamily.HELVETICA, 10f, Font.NORMAL, BaseColor.BLACK));
                para.Alignment = Element.ALIGN_LEFT;
                pCell = new PdfPCell(para);
                pCell.Border = Rectangle.NO_BORDER;
                pCell.HorizontalAlignment = Element.ALIGN_LEFT;
                pCell.VerticalAlignment = Element.ALIGN_TOP;
                pTable.AddCell(pCell);

                myDocument.Add(pTable);

                myDocument.Close();
            }

            if (isDownload)
            {
                response.ClearContent();
                response.ClearHeaders();
                response.ContentType = "application/pdf";
                response.AddHeader("content-disposition", "attachment; filename=DO.pdf");
                response.BinaryWrite(output.ToArray());
            }
            else
            {
                response.ClearContent();
                response.ClearHeaders();
                response.ContentType = "application/pdf";
                response.BinaryWrite(output.ToArray());
            }

            response.Flush();
            response.Clear();
            response.End();
        }
    }
}